!
! = k_date
!
! author    ::   (KOMATSU Kengo)
! version   :: 1.0
! date      :: 2006/03/05
! copyright :: Copyright (c) K.K, 2006. All rights reserved.
!
!
! == 
!
! ֤˴ؤ subroutines, functions 
!
! ΥץΥ֥롼 MJD Ǥ julday Ȥ֥롼
! ѤƤޤ {Numerical Recipes in 
! Fortran 90}[http://library.lanl.gov/numerical/bookf90pdf.html] 
! B1 Preliminaries ˽񤫤ƤΤǤޤ julday Ʊ
! 21 Introduction to Fortran 90 Language Features ˽񤫤Ƥ
! nrutil  nrtype ˰¸Ƥޤ
!
! readDate  :: ǯʬäɸϤɤ߹ࡣ
! DayOfYear :: ѿ year  (Day of Year) ֤
!              110(UT)  Day of Year 1.0 ȤƤޤ
! MJD       :: 齤ꥦ֤
!
!
module k_date

  interface readDate
     module procedure readDate
  end interface

  interface DayOfYear
     module procedure DayOfYear
  end interface

  interface MJD
     module procedure MJD
  end interface

contains

  subroutine readDate(year,month,day,hour,minute,second)
    !
    ! ǯʬäɸϤɤ߹ࡣ
    !
    integer, intent(out) :: year
    integer, intent(out) :: month
    integer, intent(out) :: day
    integer, intent(out) :: hour
    integer, intent(out) :: minute
    integer, intent(out) :: second
    write(*,*) 'Year ?'   ; read(*,*) year
    write(*,*) 'Month ?'  ; read(*,*) month
    write(*,*) 'Day ?'    ; read(*,*) day
    write(*,*) 'Hour ?'   ; read(*,*) hour
    write(*,*) 'Minute ?' ; read(*,*) minute
    write(*,*) 'Second ?' ; read(*,*) second
    write(*,'(a,i4,a,i2,a,i2,a,i2,a,i2,a,i2)')                        &
         & 'date::', year, '/', month,  '/', day,   ' ',              &
         &           hour, ':', minute, ':', second
  end subroutine readDate

  real(8) function DayOfYear(year,month,day,hour,minute,second) result(result)
    !
    ! ѿ year  (Day of Year) ֤
    !
    integer, intent(in)           :: year     ! ǯ
    integer, intent(in)           :: month    ! 
    integer, intent(in)           :: day      ! 
    integer, intent(in), optional :: hour     ! 
    integer, intent(in), optional :: minute   ! ʬ
    integer, intent(in), optional :: second   ! 
    if (present(second)) then
       result = MJD(year,month,day,hour,minute,second)
    else if (present(minute)) then
       result = MJD(year,month,day,hour,minute)
    else if (present(hour)) then
       result = MJD(year,month,day,hour)
    else
       result = MJD(year,month,day)
    end if
    result = result - MJD(year,1,1) + 1.0
  end function DayOfYear

  real(8) function MJD(year,month,day,hour,minute,second) result(result)
    !
    ! 齤ꥦ֤
    !
    integer, intent(in)           :: year    ! ǯ
    integer, intent(in)           :: month   ! 
    integer, intent(in)           :: day     ! 
    integer, intent(in), optional :: hour    ! 
    integer, intent(in), optional :: minute  ! ʬ
    integer, intent(in), optional :: second  ! 
    integer, external             :: julday  ! ꥦ
                                             ! (4713ǯ1112:00)
    result = julday(month,day,year) - 2400000.5
    if (present(hour)) then
       result = result + hour/24.0
    end if
    if (present(minute)) then
       result = result + minute/24.0/60.0
    end if
    if (present(second)) then
       result = result + second/24.0/60.0/60.0
    end if
  end function MJD

end module k_date
